# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from .sdarray import *
from .sdproperty import *
from .sdvalue import *
from .sdresource import *
from .sdapiobject import *
from .sdproperty import *
from .sdproperty import *
from .sdresource import *
from .sdapiobject import *
from .apiexception import APIException

class SDMetadataDict(SDAPIObject):
    """
    Dictionary of SDProperties. These properties are to be interprepeted as key-value pairs.
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDMetadataDict
        """
        super(SDMetadataDict, self).__init__(APIContext, handle, *args, **kwargs)

    def getProperties(self) -> Optional[SDArray[SDProperty]]:
        """
        Get all properties of this SDMetadataDict.

        """
        outSDPropertyArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDMetadataDict_getProperties(self.mHandle, ctypes.byref(outSDPropertyArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDPropertyArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDPropertyArray.value, ownHandle=True)

    def getPropertyFromId(self, sdPropertyId : str) -> Optional[SDProperty]:
        """
        Get the property that matches the specified identifier.
        Can generate the following error code(s):
        - ``InvalidArgument``: **sdPropertyId** was not a valid string.
        - ``ItemNotFound``: no *SDProperty* with the provided name was found.

        :param sdPropertyId: The identifier of the property we want to retrieve
        """
        outSDProperty = ctypes.c_void_p()
        _res = self.mAPIContext.SDMetadataDict_getPropertyFromId(self.mHandle, ctypes.create_string_buffer(sdPropertyId.encode('utf-8')), ctypes.byref(outSDProperty))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDProperty, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDProperty.value, ownHandle=True)

    def getPropertyValue(self, sdProperty : SDProperty) -> Optional[SDValue]:
        """
        Get the value of the specified property.
        Can generate the following error code(s):
        - ``InvalidArgument``: **sdProperty** was not a valid *SDProperty*.
        - ``ItemNotFound``: **sdProperty** was not found in the current *SDMetadataDict*.

        :param sdProperty: The property we want to retrieve the value from
        """
        outSDValue = ctypes.c_void_p()
        _res = self.mAPIContext.SDMetadataDict_getPropertyValue(self.mHandle, sdProperty.mHandle, ctypes.byref(outSDValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDValue, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDValue.value, ownHandle=True)

    def setPropertyValue(self, sdProperty : SDProperty, sdValue : SDValue) -> None:
        """
        Set the value of the specified property.
        Can generate the following error code(s):
        - ``InvalidArgument``: **sdProperty** was not a valid *SDProperty*.
        - ``InvalidArgument``: **sdValue** was not a valid *SDValue*.
        - ``ItemNotFound``: **sdProperty** was not found in the current *SDMetadataDict*.

        :param sdProperty: The property for which we want to set the value
        :param sdValue: The value to set
        """
        _res = self.mAPIContext.SDMetadataDict_setPropertyValue(self.mHandle, sdProperty.mHandle, sdValue.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getPropertyValueFromId(self, sdPropertyId : str) -> Optional[SDValue]:
        """
        Get the value of the property that matches the specified identifier.
        Can generate the following error code(s):
        - ``InvalidArgument``: **sdPropertyId** was not a valid string.
        - ``ItemNotFound``: no *SDProperty* with the provided name was found.

        :param sdPropertyId: The identifier of the property we want to retrieve
        """
        outSDValue = ctypes.c_void_p()
        _res = self.mAPIContext.SDMetadataDict_getPropertyValueFromId(self.mHandle, ctypes.create_string_buffer(sdPropertyId.encode('utf-8')), ctypes.byref(outSDValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDValue, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDValue.value, ownHandle=True)

    def setPropertyValueFromId(self, sdPropertyId : str, sdValue : SDValue) -> None:
        """
        Set the value of the property that matches the specified identifier. If the property doesn't exists, it is automatically created.
        Can generate the following error code(s):
        - ``InvalidArgument``: **sdPropertyId** was not a valid string.
        - ``InvalidArgument``: **sdValue** was not a valid *SDValue*.
        - ``InvalidValue``: **sdPropertyId** was not a valid XML tag name.
        - ``NotSupported``: a *SDProperty* with the given name already exists, and is of type URL (changing property type is not supported).

        :param sdPropertyId: The identifier of the property for which we want to set the value
        :param sdValue: The value to set
        """
        _res = self.mAPIContext.SDMetadataDict_setPropertyValueFromId(self.mHandle, ctypes.create_string_buffer(sdPropertyId.encode('utf-8')), sdValue.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def setPropertyURLFromResource(self, sdPropertyId : str, sdResource : SDResource) -> None:
        """
        Set an URL pointing to the specified resource as value for the property that matches the specified identifier. If the property doesn't exists, it is automatically created.
        Can generate the following error code(s):
        - ``InvalidArgument``: **sdPropertyId** was not a valid string.
        - ``InvalidArgument``: **sdResource** was not a valid *SDResource*.
        - ``InvalidValue``: **sdPropertyId** was not a valid XML tag name.
        - ``NotSupported``: a *SDProperty* with the given name already exists, and is of type *string* (changing property type is not supported).

        :param sdPropertyId: The identifier of the property for which we want to set the value
        :param sdResource: The value to set
        """
        _res = self.mAPIContext.SDMetadataDict_setPropertyURLFromResource(self.mHandle, ctypes.create_string_buffer(sdPropertyId.encode('utf-8')), sdResource.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def deleteProperty(self, sdProperty : SDProperty) -> None:
        """
        Delete the specified property
        Can generate the following error code(s):
        - ``InvalidArgument``: **sdProperty** was not a valid *SDProperty*.
        - ``ItemNotFound``: **sdProperty** was not found in the current *SDMetadataDict*.

        :param sdProperty: The property to remove
        """
        _res = self.mAPIContext.SDMetadataDict_deleteProperty(self.mHandle, sdProperty.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

